<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Escuela Profesional de Agronomía - Facultad de Ciencias Agrarias - UNSM">
    <meta name="keywords" content="UNSM, Agronomía, Ciencias Agrarias, Universidad San Martin">
    <meta name="author" content="Universidad Nacional de San Martin">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#4CAF50">

    <title>Escuela de Agronomía - UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../../../imagenes/escudo unsm.png" sizes="48x48">

    <!-- Stylesheet Principal -->
    <link rel="stylesheet" href="../../../css/style.css">
    <!-- Stylesheet Ciencias Agrarias -->
    <link rel="stylesheet" href="../css/styleAgra.css">
    <!-- Stylesheet Agronomía -->
    <link rel="stylesheet" href="css/styleAgro.css?v=1.0">
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en Facebook" aria-label="Página oficial de Facebook de la UNSM">
                    <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="Síguenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="../../../imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="Síguenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../../../imagenes/logo telefono.png" alt="Teléfono" class="contact-icon" width="18" height="18">
                    <span>(+51) (042) 48 0159</span>
                </span>
                <span>
                    <img src="../../../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18">
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../../../" aria-label="Ir a la página principal de UNSM">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Martín" width="auto" height="70">
                </a>
            </div>

            <!-- Botón Hamburguesa para móvil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menú de navegación" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegación principal">
                <div class="mobile-nav-logo">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menú Nosotros">
                            <li><a href="../../../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../../../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../../../nosotros/mision/indexMision.php">Nuestra Misión y Visión</a></li>
                            <li><a href="../../../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../../../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../../../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../../../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../../../nosotros/calendarioAcade/indexCale.php">Calendario Académico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menú Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../../../oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../../../oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Académico</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../../../admision/indexAdmin.php">ADMISIÓN</a></li>
                    <li><a href="../../../#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../../../#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menú Facultades">
                            <li class="has-submenu">
                                <a href="../../ciencias agrarias/indexAgra.php" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../agronomia/indexAgro.php">Agronomía</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ciencias-salud" aria-haspopup="true" aria-expanded="false">Ciencias de la Salud</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias de la Salud">
                                    <li><a href="#obstetricia">Obstetricia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#medicina-veterinaria" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                    <li><a href="#medicina-veterinaria-carrera">Medicina Veterinaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ingenieria-agroindustrial" aria-haspopup="true" aria-expanded="false">Ingeniería Agroindustrial</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Agroindustrial">
                                    <li><a href="#ing-agroindustrial">Ingeniería Agroindustrial</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ingenieria-civil" aria-haspopup="true" aria-expanded="false">Ingeniería Civil y Arquitectura</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Civil y Arquitectura">
                                    <li><a href="#arquitectura">Arquitectura</a></li>
                                    <li><a href="#ingenieria-civil-carrera">Ingeniería Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ingenieria-sistemas" aria-haspopup="true" aria-expanded="false">Ingeniería de Sistemas e Informática</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería de Sistemas">
                                    <li><a href="#ing-sistemas">Ingeniería de Sistemas e Informática</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ecologia" aria-haspopup="true" aria-expanded="false">Ecología</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ecología">
                                    <li><a href="#ing-ambiental">Ingeniería Ambiental</a></li>
                                    <li><a href="#ing-sanitaria">Ingeniería Sanitaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#derecho" aria-haspopup="true" aria-expanded="false">Derecho y Ciencias Políticas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Derecho">
                                    <li><a href="#derecho-carrera">Derecho</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#medicina-humana" aria-haspopup="true" aria-expanded="false">Medicina Humana</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Humana">
                                    <li><a href="#medicina-humana-carrera">Medicina Humana</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#educacion" aria-haspopup="true" aria-expanded="false">Educación y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educación">
                                    <li><a href="#educacion-inicial">Educación Inicial</a></li>
                                    <li><a href="#educacion-primaria">Educación Primaria</a></li>
                                    <li><a href="#educacion-secundaria">Educación Secundaria</a></li>
                                    <li><a href="#psicologia">Psicología</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ciencias-economicas" aria-haspopup="true" aria-expanded="false">Ciencias Económicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Económicas">
                                    <li><a href="#administracion">Administración</a></li>
                                    <li><a href="#economia">Economía</a></li>
                                    <li><a href="#contabilidad">Contabilidad</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../../../#posgrado">POSGRADO</a></li>
                    <li><a href="../../../#transparencia">TRANSPARENCIA</a></li>
                </ul>

                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Perú">
                        <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Perú" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Perú">
                    <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Perú" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Banner Agronomía -->
    <section class="agro-banner">
        <div class="banner-image">
            <img src="../imagenes/hombre-en-tierras-de-labrantio.jpg" alt="Profesional agrónomo en campo">
        </div>
        <div class="banner-overlay"></div>
        <div class="banner-content-wrapper">
            <div class="banner-header">
                <div class="banner-logo">
                    <img src="../../../imagenes/Escudos de Facultades — UNSM/FCA-UNSM-2021.png" alt="Logo Facultad de Ciencias Agrarias" width="80" height="80">
                </div>
                <div class="banner-title-section">
                    <h1>ESCUELA DE AGRONOMÍA</h1>
                    <p class="banner-breadcrumb">📍 Facultad de Ciencias Agrarias</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Sección Información con Tabs -->
    <section class="info-section">
        <div class="info-container">
            <div class="tabs-wrapper">
                <div class="tabs-buttons">
                    <button class="tab-button active" data-tab="resena">RESEÑA</button>
                    <button class="tab-button" data-tab="mision">MISIÓN</button>
                    <button class="tab-button" data-tab="vision">VISIÓN</button>
                </div>

                <div class="tabs-content">
                    <div class="tab-content active" id="resena">
                        <p>La Escuela Profesional de Agronomía forma profesionales íntegros, competitivos y con responsabilidad social, capaces de liderar procesos de investigación, producción y gestión de sistemas agrícolas sostenibles, aplicando tecnologías innovadoras y conocimientos científicos para contribuir al desarrollo agrícola de la región y el país.</p>
                        <p>Nuestros egresados están capacitados para planificar, dirigir y ejecutar actividades de producción, investigación y extensión agrícola, con un enfoque sostenible y respeto al medio ambiente, contribuyendo al desarrollo socioeconómico de la región San Martín.</p>
                    </div>
                    <div class="tab-content" id="mision">
                        <p>Formar profesionales en agronomía con sólidos conocimientos científicos, tecnológicos y humanísticos, capaces de contribuir al desarrollo sostenible del sector agrario regional y nacional, mediante la investigación, innovación y transferencia tecnológica.</p>
                    </div>
                    <div class="tab-content" id="vision">
                        <p>Ser una escuela profesional líder en la formación de agrónomos competitivos y comprometidos con el desarrollo sostenible, reconocida por su excelencia académica, investigación científica e innovación tecnológica al servicio de la sociedad.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Sección Carrera Profesional -->
    <section class="carrera-section">
        <div class="carrera-container">
            <div class="carrera-header">
                <h2>CARRERA PROFESIONAL: AGRONOMÍA</h2>
            </div>

            <div class="carrera-info-grid">
                <div class="info-card">
                    <div class="info-icon">📅</div>
                    <div class="info-details">
                        <h3>DURACIÓN DE LA CARRERA</h3>
                        <p>10 semestres académicos</p>
                    </div>
                </div>

                <div class="info-card">
                    <div class="info-icon">📚</div>
                    <div class="info-details">
                        <h3>GRADO ACADÉMICO</h3>
                        <p>Bachiller en Ciencias Agrarias</p>
                    </div>
                </div>

                <div class="info-card">
                    <div class="info-icon">🎓</div>
                    <div class="info-details">
                        <h3>TÍTULO PROFESIONAL</h3>
                        <p>Ingeniero Agrónomo</p>
                    </div>
                </div>

                <div class="info-card">
                    <div class="info-icon">📋</div>
                    <div class="info-details">
                        <h3>MODALIDAD</h3>
                        <p>Presencial</p>
                    </div>
                </div>
            </div>

            <!-- Objetivos de la Carrera -->
            <div class="objetivos-section">
                <h3>OBJETIVOS DE LA CARRERA</h3>
                <ul class="objetivos-list">
                    <li>Formar profesionales con sólidos conocimientos en ciencias agrarias y tecnologías agrícolas sostenibles.</li>
                    <li>Desarrollar capacidades de investigación e innovación para la solución de problemas del sector agrario.</li>
                    <li>Promover el uso racional y sostenible de los recursos naturales en la producción agrícola.</li>
                    <li>Contribuir al desarrollo socioeconómico de la región mediante la aplicación de tecnologías apropiadas.</li>
                    <li>Formar líderes comprometidos con el desarrollo agrícola sostenible y la seguridad alimentaria.</li>
                </ul>
            </div>
        </div>
    </section>

    <!-- Sección Noticias Recientes -->
    <section class="noticias-section">
        <div class="noticias-container">
            <h2>NOTICIAS RECIENTES</h2>
            <div class="noticias-grid">
                <article class="noticia-card">
                    <div class="noticia-image">
                        <img src="../imagenes/hombre-en-tierras-de-labrantio.jpg" alt="Noticia agronomía">
                        <span class="noticia-badge">ACADÉMICO</span>
                    </div>
                    <div class="noticia-content">
                        <h3>Estudiantes de Agronomía participan en prácticas de campo</h3>
                        <p>Los estudiantes realizaron prácticas de manejo integrado de cultivos en las instalaciones de la facultad.</p>
                        <a href="#" class="noticia-link">Leer más →</a>
                    </div>
                </article>

                <article class="noticia-card">
                    <div class="noticia-image">
                        <img src="../imagenes/jovenes-ingenieros-agricolas-trabajando-en-invernadero.jpg" alt="Investigación agrícola">
                        <span class="noticia-badge">INVESTIGACIÓN</span>
                    </div>
                    <div class="noticia-content">
                        <h3>Nuevos proyectos de investigación en cultivos amazónicos</h3>
                        <p>Docentes y estudiantes desarrollan investigaciones sobre el potencial de cultivos nativos de la región.</p>
                        <a href="#" class="noticia-link">Leer más →</a>
                    </div>
                </article>

                <article class="noticia-card">
                    <div class="noticia-image">
                        <img src="../imagenes/5114879.jpg" alt="Ceremonia de graduación">
                        <span class="noticia-badge">EVENTOS</span>
                    </div>
                    <div class="noticia-content">
                        <h3>Ceremonia de graduación de nuevos ingenieros agrónomos</h3>
                        <p>La Escuela de Agronomía celebró la graduación de su nueva promoción de profesionales.</p>
                        <a href="#" class="noticia-link">Leer más →</a>
                    </div>
                </article>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../../../imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autónomo y de carácter estatal, comprometido con la formación de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N° 177 - Morales</p>
                    <p>Tarapoto - San Martín - Perú</p>
                    <p>Central Telefónica: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rápidos</h3>
                <ul class="footer-links">
                    <li><a href="../../../admision/indexAdmin.php">Admisión</a></li>
                    <li><a href="../../../index.php#facultades">Facultades</a></li>
                    <li><a href="../../../index.php#posgrado">Posgrado</a></li>
                    <li><a href="../../../index.php#investigacion">Investigación</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="../../../index.php#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="../../../index.php#campus-virtual">Campus Virtual</a></li>
                    <li><a href="../../../index.php#repositorio">Repositorio Institucional</a></li>
                    <li><a href="../../../index.php#transparencia">Portal de Transparencia</a></li>
                    <li><a href="../../../index.php#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="../../../contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <div class="fb-page"
                    data-href="https://www.facebook.com/unsmperu"
                    data-tabs="timeline"
                    data-width="320"
                    data-height="320"
                    data-small-header="false"
                    data-adapt-container-width="true"
                    data-hide-cover="false"
                    data-show-facepile="true">
                    <blockquote cite="https://www.facebook.com/unsmperu" class="fb-xfbml-parse-ignore">
                        <a href="https://www.facebook.com/unsmperu">Universidad Nacional de San Martín - UNSM</a>
                    </blockquote>
                </div>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Martín. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Síguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="../../../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>

    <script src="../../../js/script.js" defer></script>
    <script>
        // Tabs functionality
        document.addEventListener('DOMContentLoaded', function() {
            const tabButtons = document.querySelectorAll('.tab-button');
            const tabContents = document.querySelectorAll('.tab-content');

            tabButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const targetTab = this.getAttribute('data-tab');

                    // Remove active class from all buttons and contents
                    tabButtons.forEach(btn => btn.classList.remove('active'));
                    tabContents.forEach(content => content.classList.remove('active'));

                    // Add active class to clicked button and corresponding content
                    this.classList.add('active');
                    document.getElementById(targetTab).classList.add('active');
                });
            });
        });
    </script>
</body>
</html>
